-- Play Ping Sound every x seconds, when Ripple-All=on and Play/Rec=off
-- Meo-Ada Mespotine - 29th of May 2022 - licensed under MIT-license

-- Changelog:
-- 1.0 - initial release - 22th of May 2022
-- 1.1 - sound doesn't get cut off anymore, when running multiple instances of this script - 27th of May 2022
-- 1.2 - new option that sounds are only played, when a Reaper-window is in focus(excluding ReaScript-IDE and Consolidate Tracks-dialog), can be turned off
--       shows in actionlist now, if it's turned on(allows for toolbar-buttons) plus some internal cleanup - 29th of May 2022

-- You can modify this script to check for other states as well. For this, make a copy of this script and alter the GetCurrenState-function, so it returns true, when you want to hear the sound or false, if you don't want to.
-- The rest of the code you probably don't need to touch or look at, but I added comments in case you are curious.
-- You can set various values in the next few lines to customize, how often you want the playsound to be played, its volume,
-- where the file can be found and a delay for the first time the sound is played.


-- You can change these variables to the values you prefer:
  ping_sound_filename = reaper.GetResourcePath().."/Scripts/Meo-Ada Mespotine/RippleTrackBeep.wav" -- the path and filename of the ping-
  seconds_between_each_ping=30 -- the number of seconds to wait inbetween each ping; values l.5 and 17.4 are allowed too
                              -- 0, to play the sound only once and -1 to start the sound immediately and loop it until ripple=off and/or play/rec=true
  ping_volume=0.2         -- the volume of the ping-sound; 0 for off; 10 is maximum; values like 0.1 or 3.4 are allowed too.
  ping_output_channel=0 -- the hardware-output-channel of your device, that shall play the ping sound(0 for default)
  ping_delay=0      -- the number of seconds to wait, until the sound is played for the first time(0 to start playing immediately after ripple edit=on and play/rec=off)
                    -- with this, you can avoid being annoyed immediately by the sound, when you realised yourselves, that you accidentally had ripple-all on so you have 
                    -- time to turn it off before the first ping reminds you
                    -- Is ignored, when seconds_between_each_ping is set to -1.
  ping_only_when_reaper_is_focused=true -- set to true, if the ping shall only be, when Reaper or its childwindows are focused; 
                                        -- set to false, when you want to be pinged all the time, even when another app is on focus

function GetCurrentState()
  -- This is the function you need to alter, if you want to check for something else than ripple-all and play/rec.
  -- Just get the state and return true if you want to play the sound or return false, if not.
  -- The wait-time-between two pings will be done in the rest of the code outside this function, so you don't 
  -- need to bother with that. Just return true for as long as you want to have a sound played and the rest should work automatically.
  
  local state=reaper.GetToggleCommandState(41990) -- check, if ripple-track state is on(1) or off(0)
  if reaper.GetPlayState()~=0 then state=0 end -- If you play/record currently, ignore the ripple-all-state by setting state=0. 

  if state==1 then return true else return false end
end


-- You probably don't need to look at the rest of the code from here on

function main()
  
  -- let's get first, if the Reaper window is unfocused(don't play) and if it's focused, if the 
  -- state-conditions for playing a sound are met
  local cur_state
  if IsReaperFocused()==false and ping_only_when_reaper_is_focused==true then 
    -- if the Reaper-window or any of its child-windows is not focused(means, you're in a different app), prevent soundplaying.
    cur_state=false 
  else
    -- let's get, if the sound shall be played(true) or not(false)
    cur_state=GetCurrentState()
  end
  
  -- Now we go to the counting of time and playing the sound-logic. 

  -- Some notes on how the number of seconds between each ping is calculated:
  -- Reaper executes this script approximately 33 times per second, so we need to have a counter-variable valled counter,
  -- to check, whether one second is gone(script was executed 33 times).
  -- We will use this variable in various ways. 
  -- For instance, everytime, the counter-variable reaches ping_delay*33, we will play the sound.
  -- To know, when to play the sound again, we check when the counter-variable is 33*seconds_between_each_ping.
  -- In that case, we will reset the value of counter to 0 to restart measuring the time again.
  -- In some cases, Reaper might slow down execution of this script(mouse movements or opening of some dialogs), which
  -- might to lead some slightly longer inbetween-times between two pings.
  -- If that's too annoying in practice, I'll fix it more to actual time-measuring...

  -- if cur_state is true(turned on) then do the sound magic
  if cur_state==true then
    -- if the counter reaches the delay-value in seconds (delay*33) then play the sound once
    if seconds_between_each_ping~=-1 and internal_variables_dont_change["counter"]==math.floor(ping_delay*33) then
      if internal_variables_dont_change["id"]~=nil then
        reaper.Xen_StopSourcePreview(internal_variables_dont_change["id"])
      end
      local PCM_Source=reaper.PCM_Source_CreateFromFile(ping_sound_filename)
      internal_variables_dont_change["id"]=reaper.Xen_StartSourcePreview(PCM_Source, ping_volume, false, ping_output_channel)
    elseif seconds_between_each_ping==-1 and internal_variables_dont_change["started"]~=true then
      local PCM_Source=reaper.PCM_Source_CreateFromFile(ping_sound_filename)
      internal_variables_dont_change["id"]=reaper.Xen_StartSourcePreview(PCM_Source, ping_volume, true, ping_output_channel)
      count=-1
      internal_variables_dont_change["started"]=true
    end
    internal_variables_dont_change["counter"]=internal_variables_dont_change["counter"]+1
  -- if cur_state is off(false), then reset the counter and wait, so no sound is played.
  elseif cur_state==false then
    internal_variables_dont_change["counter"]=-1
    internal_variables_dont_change["started"]=false
    if internal_variables_dont_change["id"]~=nil then
      reaper.Xen_StopSourcePreview(internal_variables_dont_change["id"])
    end
  end

  -- if the maximum time between two pings has been reached, reset the counter and restart counting again
  -- it waits for "33*seconds_between_each_ping" which is the number of times, Reaper executes the script in the background 
  -- in the amount of seconds between each ping
  if seconds_between_each_ping~=0 and internal_variables_dont_change["counter"]>=33*seconds_between_each_ping then
    internal_variables_dont_change["counter"]=0
  end
  reaper.defer(main)
end

function IsReaperFocused()
  local HWND=reaper.GetMainHwnd()
  if HWND==reaper.JS_Window_GetFocus() then return true end
  local HWND2=reaper.JS_Window_GetFocus()
  for i=0, 100 do
    if HWND==reaper.JS_Window_GetParent(HWND2) then return true end
    HWND2=reaper.JS_Window_GetParent(HWND2)
  end
  
  return false
end

function atexit()
  if internal_variables_dont_change["id"]~=nil then
    reaper.Xen_StopSourcePreview(internal_variables_dont_change["id"])
  end
  reaper.SetToggleCommandState(internal_variables_dont_change["context"][3], internal_variables_dont_change["context"][4], 0)
end

reaper.atexit(atexit)

-- check, if JS-extension is correctly installed
internal_variables_dont_change={}
if reaper.Xen_StartSourcePreview==nil then reaper.MB("JS-extension doesn't seem to be installed...", "error", 0) return end
internal_variables_dont_change["id"]=nil       -- the id of the currently playing sound; don't change
internal_variables_dont_change["counter"]=0    -- counter-variable needed by the script; don't change.
internal_variables_dont_change["context"]={reaper.get_action_context()}
reaper.SetToggleCommandState(internal_variables_dont_change["context"][3], internal_variables_dont_change["context"][4], 1)


main()
